import {VideoEl} from "../../../../src/types/preset";

export default function createVideoElement(
    videoName: string,
    categoryName: string,
    packFolderName: string,
    prewPath: string | undefined = undefined,
    previewHeight: number = 270,
    previewWidth: number = 480,
    previewThumbnail?: string
): VideoEl {

    const prev = prewPath ?
        "http://localhost:3000/ignore/preview/video/" + prewPath :
        "http://localhost:3000/ignore/preview/video/Default video prew 1.mp4"

    const thumbnailPath = "http://localhost:3000/ignore/preview/thumbnails/"

    return {
        name: videoName,
        path: `D:\\temp\\MotionBro\\${packFolderName}_by_Videolancer\\${categoryName}\\${videoName}.mp4`,
        type: "mp4",
        preview: prev,
        previewHeight: previewHeight,
        previewWidth: previewWidth,
        previewThumbnail: previewThumbnail ? thumbnailPath + previewThumbnail : undefined
    }
}

